;==========================================================================
;Version history:
;==========================================================================
;2010/12/24     First edition
;2011/01/19     Optimize the service routine of software PWM
;               Add 32-level duty for software PWM
;==========================================================================
        .INCLUDE        Inc\IO_Event.inc
;==========================================================================
        .CODE
        .IF     CPU_Clock/(D_SoftPWMFreq*D_SoftPWMLevel) > 4096
D_PWM_Freq:     .EQU    4096 - (CPU_Clock/8/(D_SoftPWMFreq*D_SoftPWMLevel))
D_PWM_Source:   .EQU    D_S1_FcpuBy8 + D_S2_1
        .ELSE
D_PWM_Freq:     .EQU    4096 - (CPU_Clock/(D_SoftPWMFreq*D_SoftPWMLevel))
D_PWM_Source:   .EQU    D_S1_Fcpu + D_S2_1
        .ENDIF
;==========================================================================
;Purpose: Power-up initial for software PWMIOs
;Input: None
;Return: None
;Destroy: A, X, Y
;==========================================================================
F_SW_PWM_PowerUpInitial:
        LDX     #00H
        %SW_PWMIO_Initial       D_IO_EventNum   ;Initialize PWM I/Os as output low

        LDA     #<D_PWM_Freq                    ;Set timer
        STA     P_TMC_DataL
        LDA     #>D_PWM_Freq
        STA     P_TMC_DataH
        LDA     #(D_PWM_Source + D_TMR_Enable)
        STA     P_TMC_Ctrl

Order:  .VAR    0
        %SW_PWM_InitDuty        D_IO_EventNum   ;Initialize all PWMIOs duties

        LDA     P_INT_CtrlL                     ;Enable timer interrupt
        ORA     #D_TMCIntEn
        STA     P_INT_CtrlL
        CLI
        RTS
;==========================================================================
;Purpose: Wake-up initial for software PWMIOs
;Input: None
;Return: None
;Destroy: A, X, Y
;==========================================================================
F_SW_PWM_WakeUpInitial:
        LDX     #00H
        %SW_PWMIO_Initial       D_IO_EventNum   ;Initialize PWM I/Os as output low

        LDA     #<D_PWM_Freq                    ;Set timer
        STA     P_TMC_DataL
        LDA     #>D_PWM_Freq
        STX     P_TMC_DataH
        LDA     #(D_PWM_Source + D_TMR_Enable)
        STA     P_TMC_Ctrl

Order:  .VAR    0
        %SW_PWM_InitDuty        D_IO_EventNum   ;Initialize all PWMIOs duties

        LDA     P_INT_CtrlL                     ;Enable timer interrupt
        ORA     #D_TMCIntEn
        STA     P_INT_CtrlL
        CLI
        RTS
;==========================================================================
;Purpose: Disable all software PWMIOs
;Input: None
;Return: None
;Destroy: A, X, Y
;==========================================================================
F_IOEventEnd:
        SEI
        LDX     #00H

Order:  .VAR    0
        %SW_PWM_Stop    D_IO_EventNum   ;Set all PWMIOs as output low

        CLI
        RTS
;==========================================================================
F_SW_PWM_Service:
        .IF MIDI = ON
        LDA     R_MIDIStatus            ;Check if MIDI is playing
        AND     #D_MIDIEn
        BNE     L_SW_PWM_Srv?
        .ENDIF

        .IF SW_ChA = ON
            .IF ChA_Evt = ON
        %IsActiveChA                    ;Check if SW_ChA is active
        BCS     L_SW_PWM_Srv?
            .ENDIF
        .ENDIF

        .IF SW_ChB = ON
            .IF ChB_Evt = ON
        %IsActiveChB                    ;Check if SW_ChB is active
        BCS     L_SW_PWM_Srv?
            .ENDIF
        .ENDIF
L_SW_PWM_Exit?:
        RTS

L_SW_PWM_Srv?:
        LDX     #00H
        %SW_PWM_Process D_IO_EventNum
        RTS
;==========================================================================
F_IOEventProcess:
        SEC
        SBC     #80H
        CMP     #D_IO_EventNum
        BCS     L_Exit?                 ;If index is greater than maximum event number, exit
        ASL     A
        TAX
        LDA     T_PWM_SetTable,X
        STA     R_Index
        LDA     T_PWM_SetTable+1,X
        STA     R_Index+1
        JMP     (R_Index)
L_Exit?:
        RTS

L_PWM_Start0:
        .IF D_IO_EventNum > 0
        TYA
        %SW_PWM_SetDuty 0
        %SW_PWM_Enable  0
        .ENDIF
        RTS

L_PWM_Start1:
        .IF D_IO_EventNum > 1
        TYA
        %SW_PWM_SetDuty 1
        %SW_PWM_Enable  1
        .ENDIF
        RTS

L_PWM_Start2:
        .IF D_IO_EventNum > 2
        TYA
        %SW_PWM_SetDuty 2
        %SW_PWM_Enable  2
        .ENDIF
        RTS

L_PWM_Start3:
        .IF D_IO_EventNum > 3
        TYA
        %SW_PWM_SetDuty 3
        %SW_PWM_Enable  3
        .ENDIF
        RTS

L_PWM_Start4:
        .IF D_IO_EventNum > 4
        TYA
        %SW_PWM_SetDuty 4
        %SW_PWM_Enable  4
        .ENDIF
        RTS

L_PWM_Start5:
        .IF D_IO_EventNum > 5
        TYA
        %SW_PWM_SetDuty 5
        %SW_PWM_Enable  5
        .ENDIF
        RTS

L_PWM_Start6:
        .IF D_IO_EventNum > 6
        TYA
        %SW_PWM_SetDuty 6
        %SW_PWM_Enable  6
        .ENDIF
        RTS

L_PWM_Start7:
        .IF D_IO_EventNum > 7
        TYA
        %SW_PWM_SetDuty 7
        %SW_PWM_Enable  7
        .ENDIF
        RTS

L_PWM_Start8:
        .IF D_IO_EventNum > 8
        TYA
        %SW_PWM_SetDuty 8
        %SW_PWM_Enable  8
        .ENDIF
        RTS

L_PWM_Start9:
        .IF D_IO_EventNum > 9
        TYA
        %SW_PWM_SetDuty 9
        %SW_PWM_Enable  9
        .ENDIF
        RTS

L_PWM_Start10:
        .IF D_IO_EventNum > 10
        TYA
        %SW_PWM_SetDuty 10
        %SW_PWM_Enable  10
        .ENDIF
        RTS

L_PWM_Start11:
        .IF D_IO_EventNum > 11
        TYA
        %SW_PWM_SetDuty 11
        %SW_PWM_Enable  11
        .ENDIF
        RTS

L_PWM_Start12:
        .IF D_IO_EventNum > 12
        TYA
        %SW_PWM_SetDuty 12
        %SW_PWM_Enable  12
        .ENDIF
        RTS

L_PWM_Start13:
        .IF D_IO_EventNum > 13
        TYA
        %SW_PWM_SetDuty 13
        %SW_PWM_Enable  13
        .ENDIF
        RTS

L_PWM_Start14:
        .IF D_IO_EventNum > 14
        TYA
        %SW_PWM_SetDuty 14
        %SW_PWM_Enable  14
        .ENDIF
        RTS

L_PWM_Start15:
        .IF D_IO_EventNum > 15
        TYA
        %SW_PWM_SetDuty 15
        %SW_PWM_Enable  15
        .ENDIF
        RTS

L_PWM_Start16:
        .IF D_IO_EventNum > 16
        TYA
        %SW_PWM_SetDuty 16
        %SW_PWM_Enable  16
        .ENDIF
        RTS

L_PWM_Start17:
        .IF D_IO_EventNum > 17
        TYA
        %SW_PWM_SetDuty 17
        %SW_PWM_Enable  17
        .ENDIF
        RTS

L_PWM_Start18:
        .IF D_IO_EventNum > 18
        TYA
        %SW_PWM_SetDuty 18
        %SW_PWM_Enable  18
        .ENDIF
        RTS

L_PWM_Start19:
        .IF D_IO_EventNum > 19
        TYA
        %SW_PWM_SetDuty 19
        %SW_PWM_Enable  19
        .ENDIF
        RTS

L_PWM_Start20:
        .IF D_IO_EventNum > 20
        TYA
        %SW_PWM_SetDuty 20
        %SW_PWM_Enable  20
        .ENDIF
        RTS

L_PWM_Start21:
        .IF D_IO_EventNum > 21
        TYA
        %SW_PWM_SetDuty 21
        %SW_PWM_Enable  21
        .ENDIF
        RTS

L_PWM_Start22:
        .IF D_IO_EventNum > 22
        TYA
        %SW_PWM_SetDuty 22
        %SW_PWM_Enable  22
        .ENDIF
        RTS

L_PWM_Start23:
        .IF D_IO_EventNum > 23
        TYA
        %SW_PWM_SetDuty 23
        %SW_PWM_Enable  23
        .ENDIF
        RTS

L_PWM_Start24:
        .IF D_IO_EventNum > 24
        TYA
        %SW_PWM_SetDuty 24
        %SW_PWM_Enable  24
        .ENDIF
        RTS

L_PWM_Start25:
        .IF D_IO_EventNum > 25
        TYA
        %SW_PWM_SetDuty 25
        %SW_PWM_Enable  25
        .ENDIF
        RTS

L_PWM_Start26:
        .IF D_IO_EventNum > 26
        TYA
        %SW_PWM_SetDuty 26
        %SW_PWM_Enable  26
        .ENDIF
        RTS

L_PWM_Start27:
        .IF D_IO_EventNum > 27
        TYA
        %SW_PWM_SetDuty 27
        %SW_PWM_Enable  27
        .ENDIF
        RTS

L_PWM_Start28:
        .IF D_IO_EventNum > 28
        TYA
        %SW_PWM_SetDuty 28
        %SW_PWM_Enable  28
        .ENDIF
        RTS

L_PWM_Start29:
        .IF D_IO_EventNum > 29
        TYA
        %SW_PWM_SetDuty 29
        %SW_PWM_Enable  29
        .ENDIF
        RTS

L_PWM_Start30:
        .IF D_IO_EventNum > 30
        TYA
        %SW_PWM_SetDuty 30
        %SW_PWM_Enable  30
        .ENDIF
        RTS

L_PWM_Start31:
        .IF D_IO_EventNum > 31
        TYA
        %SW_PWM_SetDuty 31
        %SW_PWM_Enable  31
        .ENDIF
        RTS
;==========================================================================
T_PWM_SetTable:
        .DW     L_PWM_Start0
        .DW     L_PWM_Start1
        .DW     L_PWM_Start2
        .DW     L_PWM_Start3
        .DW     L_PWM_Start4
        .DW     L_PWM_Start5
        .DW     L_PWM_Start6
        .DW     L_PWM_Start7

        .DW     L_PWM_Start8
        .DW     L_PWM_Start9
        .DW     L_PWM_Start10
        .DW     L_PWM_Start11
        .DW     L_PWM_Start12
        .DW     L_PWM_Start13
        .DW     L_PWM_Start14
        .DW     L_PWM_Start15

        .DW     L_PWM_Start16
        .DW     L_PWM_Start17
        .DW     L_PWM_Start18
        .DW     L_PWM_Start19
        .DW     L_PWM_Start20
        .DW     L_PWM_Start21
        .DW     L_PWM_Start22
        .DW     L_PWM_Start23

        .DW     L_PWM_Start24
        .DW     L_PWM_Start25
        .DW     L_PWM_Start26
        .DW     L_PWM_Start27
        .DW     L_PWM_Start28
        .DW     L_PWM_Start29
        .DW     L_PWM_Start30
        .DW     L_PWM_Start31
;==========================================================================
